# ShareKinks Cloudflare Worker (share link backend)

This Worker implements the `/api/share` endpoints expected by the frontend refactor:

- `POST /api/share` → create a share; returns `{ id, manageToken }`
- `GET /api/share/:id` → fetch stored state; returns `{ state }`
- `PUT /api/share/:id` → update stored state (requires `Authorization: Bearer <manageToken>`)
- `DELETE /api/share/:id` → delete share (requires `Authorization: Bearer <manageToken>`)

## Setup

1) Create a KV namespace in your Cloudflare account (Dashboard → Workers & Pages → KV).

2) Put the namespace IDs into `wrangler.jsonc`:

    ```jsonc
    "kv_namespaces": [
      { "binding": "SHAREKINKS_KV", "id": "...", "preview_id": "..." }
    ]
    ```

3) Install deps:

    ```bash
    npm install
    ```

4) Local dev:

    ```bash
    npm run dev
    ```

5) Deploy:

    ```bash
    npm run deploy
    ```

## Configure the frontend

In `wwwroot/js/app.js`, set the share API base (if you aren't hosting Worker under the same origin):

- Same-origin: `const SHARE_API_BASE = ""`
- Separate host: `const SHARE_API_BASE = "https://your-worker.your-domain"`

## Notes

- The management token is **never** included in a query string.
- The Worker stores only a SHA-256 hash of the management token (not the token itself).
- Responses include CORS headers so you can host the Worker on a separate subdomain if you want.
