# About ShareKinks.com

In the kink world, sometimes tops/doms and bottoms/subs have difficulty communicating what they want or don't want. ShareKinks.com was created by [gayhypnoguy](https://linktr.ee/gayhypnoguy) (with a lot of help from GPT 5.2 and an icon created by Wednesday) to address this problem without requiring anyone to create an account.

## Frequently asked Questions (FAQs)

### How do I use this site?

Browse the kink list using search, categories, or scrolling. For any kink role, select an interest level to indicate interest or mark it as a Hard Limit. Tap again to clear your selection.

If you don’t have an opinion on a kink, leave it unselected; don’t choose **None** unless you’re interested in the kink but not that specific role. You can add notes to provide extra context.

Enable **Only kinks with selected interests** to show only the kinks you’ve rated, which makes the list easier to share. Choose a sort order, then click on the **Share...** button the generate a public share link and a management link. The public share link can be shared with anyone you want. Keep the management link private. It can be used to update the selections at the shared link or delete the shared link.

### How is this different than [insert website]?

ShareKinks.com has a unique set of features compared to other kink-sharing sites:

- It is mobile-friendly and responsive.
- It doesn't require (or even offer) an account.
- It doesn't require you to fill out every kink option or complete a quiz to get a sharable link.
- The share button actually works.
- Clear descriptions are provided for every kink and role.
- You can add notes to any kink role to provide clarifying details.
- You can change your selections without needing a new share link
- You can delete the share link at any time.

### I can't believe you included [kink name] in here! That's gross!

That's not a question. 😝 Select **Hard Limit** if you have a strong dislike of a particular kink or role; it's what that button is there for. One of the goals of this project is to list as many kinks as possible, as long as the activity is between consenting adults.

### The list is missing one or more of my kinks. How can those get added?

I'm working on adding more kinks to the list as I have time. Contact me on Telegram or Discord and we can talk about it.

### Talk nerdy to me. How does this website work?

At a high level, this site is a privacy-first, browser-driven application with a deliberately tiny backend whose only responsibility is storing and retrieving shared selections. There are no accounts, no trackers, and no persistent user identity.

The core design principle is to **minimize what data exists at all**, not just how it’s protected.

#### Kink data (the taxonomy)

- All kink definitions are stored as static YAML files on the website.
- Every browser loads the same read-only reference data.
- This data contains **no user information**.

The kink list is treated as _code_, not user-generated content.

#### User selections (local-only state)

- As you click interest buttons, selections are stored only in memory in your browser.
- Nothing is sent to the server while you browse or make selections.

No account. No cookies. No analytics.

#### Legacy sharing (URL fragments)

- Older links encode selections directly in the URL fragment (`#`).
- These links are still supported for backwards compatibility.
- URL fragments are processed entirely client-side and are never sent to the server.

This approach is private, but produces URLs that are too long to be used in messaging and link sharing platforms.

#### Modern sharing (short links with built-in permissions)

When you click "Share":

1. Your selections are serialized into a compact state object.
2. That state is sent to a small API running on Cloudflare Workers.
3. The backend stores:
    - The state object.
    - A random public ID.
    - A separate secret edit token, stored only as a hash.
    - Schema version numbers.
    - Timestamps for record creation and modification.
4. The app shows you:
    - A public share link (view-only).
    - A management link (edit/delete).

How permissions work:

- Anyone with the public link can view the selections.
- Only someone with the management link can modify or delete them.
- There is no login or user record; the link itself is the permission.

The secret part of the management link lives in the URL fragment (`#`), which browsers do not send automatically.

### How much of this project was made by AI?

Almost all of it. I already had an idea in my head of how I wanted the website to function and its architecture, but I'm not a web frontend UX developer. So, I started by giving GPT-5.2 this prompt:

> I'm wanting to create a mobile-friendly UI for people to list and share their kinks with others, without having that data stored by a third party. To do this, I want to develop a bootstrap page the loads details from a YAML file that contains:
>
> - The name of the kink
> - A short description of the kink that is useful for someone who has never heard of it before
> - Names and descriptions of roles related to the kink
>
> A separate YAML file contains an interest scale.
>
> Using this information, the user can add a kink role or roles, and in interest level in each role.
>
> For easy sharing that does not store data on a server, the user's selections should create a URL using anchor tag values.
>
> Due to the nature of this project, do not use chats in this project in your memory, or reference it in chats outside of this project.

And it generated a surprisingly complete first draft. It understood that by "anchor tags" I actually meant URL fragments (The part of the URL after the `#`, which is not sent to web servers).

From there I used follow-up prompts to iterate and add new features such as categories and search, which it did with ease.

I used other prompts to create a script to validate and sort the YAML files I created, and to create a ZIP archive for sharing the project, which you can download at the link below.

GPT-5.2 recommended using `lz-string` when I mentioned that the initial approach to encoding URLs was creating URLs that were far too long. Impressively, when I asked for code to do that, it included backwards-compatibility with the  old method without being prompted for that feature, and included upgrading existing URLs on page load when I asked for that.

When those URLs were still to long, ChatGPT and I brainstormed solutions until coming up with the site as it is today.

I initially used GPT-5.2 or the [mistral-small3.2](https://ollama.com/library/mistral-small3.2) local LLM (Mistral is the only family of high-quality local LLM models that didn't refuse to answer questions about sex and kinks) for generating descriptions and roles for a kink I didn't know much about, then later cleaned up the descriptions myself later to sound less AI-generated.

The site logo was created by a fellow hypnokinkster by the name of Wednesday.

### Why not crowdsource kinks from pull requests on GitHub or GitLab?

Explicit sexual and fetish content of this nature is not permitted on those platforms.

### Can I get a copy of this project?

Absolutely! You can find an archive of the project [at this link](https://sharekinks.com/sharekinks.zip).

## Project layout

- `.vscode` - Directory for Visual Studio Code settings.
  - `launch.json` - Debugging profiles.
  - `settings.json` - Workspace settings.
  - `tasks.json` - Workspace tasks.
- `tools` - A directory containing scripts used to maintain the project.
  - `archive.py` - A script that archives the project into `wwwroot/sharekinks.zip`.
  - `qa.py` - A script that ensures that the YAML files are properly and consistently formatted.
  - `requirements.txt` - A list of Python dependencies for `qa.py`.
- `wwwroot` - The directory containing the website files.
  - `css` - The directory containing the CSS files.
    - `app.cs` - Application0specific stylesheet.
    - `bootstrap.min.csa` - The stylesheet for the Bootstrap web frontend framework.
  - `icons` - A directory containing the website's favicon in many different sizes and formats.
  - `images` - A directory containing images for the website.
    - `card.webp` - The image shown in link previews on social media.
  - `js` A directory containing JavaScript files
    - `app.js` - The custom JavaScript for the application.
    - `bootstrap.min.js` - JavaScript for the Bootstrap web frontend application.
    - `js-yaml.min.js` - The Javascript fot ja-yaml.
    - `lz-string.min.js` - lz-string compression support.
  - `yaml` - A directory containing YAML files used by the project.
    - `interest_scale.yml` - Defines the interest scale.
    - `kink_categories.yml` - Defines the kink categories.
    - `kinks.yml` - Defines the kinks and roles.
  - `_headers` - Defines the HTTP headers to be sent by Cloudflare pages.
  - `about.html` - The about page HTML.
  - `index.html` - The pain page HTML.
  - `sharekinks.zip` A ZIP archive of the project.
  - `site.webmanifest` - Allows the website to run offline as an installable Progressive Web Application (PWA).
- `.gitignore` A list of files for `git` to ignore.
- `.markdownlint.yml` - Suppresses `markdownlint` warnings about headers ending with question marks in the FAQ.
- `LICENSE` - The project license.
- `Makefile` - The project makefile.
- `README.md` - This README file.

## Share links backend

A Cloudflare Worker backend for persistent short share links lives in `cf-worker/`.
See `cf-worker/README.md`.
